#ifndef __CBpmToTimePanel__
#define __CBpmToTimePanel__

#include <EGUI.h>
#include <EMusic.h>

namespace Exponent
{
	namespace SCal
	{
		/**
		 * @class CBpmToTimePanel CBpmToTimePanel.hpp
		 * @brief Bpm to time convertor
		 *
		 * @date 17/12/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2007 Exp Digital Uk.\n
		 * This file forms part of the example projects for the Infinity API.\n
		 * You may not redistribute either the source code or the compiled binary.\n
		 * The Infinity API is covered by a fair use licence which you should have recieved with this\n
		 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
		 * 
		 * $Id: CBpmToTimePanel.hpp,v 1.4 2007/02/11 02:20:27 paul Exp $
		 */
		class CBpmToTimePanel : public CControlPanel, public IActionListener
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param root The root control that this control is being added to
			 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
			 * @param area The area of this control relative to the root controls top left
			 */
			CBpmToTimePanel(IControlRoot *root, const long uniqueId, const CRect &area);

			/**
			 * Destruction
			 */
			virtual ~CBpmToTimePanel();

//	===========================================================================

			/**
			 * Handle the action event
			 */
			virtual void handleActionEvent(const CActionEvent &event);

//	===========================================================================

		protected:

//	===========================================================================

			/**
			 * Compute tempo shift
			 */
			void computeTimeFromBpm();

//	===========================================================================
			
			/**
			 * @enum EControlIds
			 * @brief Enumeration of control identifiers
			 */
			enum EControlIds
			{
				e_timeFromBpmBpmEditBox = 0,					/**< Edit box for length */
				e_timeFromBpmBeatsEditBox,						/**< Beats edit box */
			};

//	===========================================================================

			CTextEdit *m_timeFromBpmBpmEditBox;					/**< Edit box for the length */
			CTextEdit *m_timeFromBpmBeatsEditBox;				/**< Edit box for the number of beats */
			CTextLabel *m_timeFromBpmOutputValueLabel;			/**< output label */
		};
	}
}
#endif	// End of CBpmToTimePanel.hpp